

loadCss( '/static/app/widget/email/css/email.css' );

import { EmailViewWidget } from './EmailViewWidget.js';


export class EmailListWidget {
	
	
	
	tpl = `
	<div class="email-list-widget">
		<div class="page-header">
		<!--
			<div class="toolbox">
				<a href="javascript:void(0);" [onclick]="widget.addEmail_Click" class="fa fa-plus"></a>
			</div>
		-->	
			
			<h1>{{_('E-mails')}}</h1>
		</div>
		
		
		<div class="email-list-widget">
			<input type="text" 
					name="q" 
					placeholder="{{_('Search...')}}"
					autocomplete="off"
					[onchange]="widget.search" />
			
			<div id="search-result" class="email-list-result-container"></div>
			
			<hr/>
			
			<div id="email-preview"></div>
		</div>
	</div>
	`;
	
	tplSearch = `
		<table class="table table-email">
			<thead>
				<tr>
					<th class="col-customer">{{_('Customer')}}</th>
					<th class="col-to">{{_('To')}}</th>
					<th class="col-subject">{{_('Subject')}}</th>
					<th class="col-status">{{_('Status')}}</th>
					<th class="col-created">{{_('Created')}}</th>
				</tr>
			</thead>
			<tbody ez-for="emails" ez-item="e" id="email-rows">
				<tr class="pointer" 
					[onclick]="widget.viewEmail_Click"
					[ondblclick]="widget.email_DblClick" 
					[email]="e">
					<td class="col-customer">{{e.customerName ?? ''}}</td>
					<td class="col-to">{{e.toName ?? ''}} {{ e.toEmail ?? '' }}</td>
					<td class="col-subject">{{e.subject}}</td>
					<td class="col-status">{{_('emailStatus.'+e.status)}}</td>
					<td class="col-created">{{ format_datetime(e.created) }}</td>
				</tr>
			</tbody>
			<tr ez-if="emails.length == 0" class="no-results-found">
				<td colspan="100%">{{_('No results found')}}</td>
			</tr>
		</table>
	`;
	
	
	
	container = null;
	
	lastResponse = null;
	
	
	init(e) {
		
		this.container = e;
		
		
		this.render();
	}
	
	
	async search() {
		this.searchNextCalled = false;
		
		let r = await postJson('/service/email/message.do', {
			a: 'search',
			q: $('input[name=q]').val()
		});
		
		let json = await r.json();
		
		this.lastResponse = json;
		
		let tpl = new EzTemplate('#search-result');
		tpl.loadHtml( this.tplSearch );
		tpl.setObject('widget', this);
		tpl.setVar('emails', json.emails);
		tpl.render();
	}
	
	searchNextCalled = false;
	async searchNext() {
		if (this.searchNextCalled)
			return;
		
		
		this.searchNextCalled = true;
		
		let nextStart = this.lastResponse.start + this.lastResponse.pageSize;
		
		if ( nextStart >= this.lastResponse.rowCount ) {
			return;
		}
		
		let r = await postJson('/service/email/message.do', {
			a: 'search',
			q: $('input[name=q]').val(),
			start: nextStart
		});
		
		let json = await r.json();
		console.log('json', json);
		
		
		let eztpl = document.getElementById('email-rows').eztemplate;
		for(let i=0; i < json.emails.length; i++) {
			console.log('go', json.emails[i]);
			eztpl.createRecord( json.emails[i] );
		}
		
		this.lastResponse = json;
		this.searchNextCalled = false;
	}
	
	
	
	
	addEmail_Click() {
		gotoRoute( '/email/edit/' );
	}
	
	
	viewEmail_Click( evt, tr ) {
		let id = tr.email.emailMessageId;
		
		this.renderEmail(id);
	}
	
	
	loadMailTimeout = null;
	lastLoadedEmail = null;
	async renderEmail( emailMessageId ) {
		
		if ( this.lastLoadedEmail == emailMessageId )
			return;
		
		$('#email-preview').empty();
		showLoadingForm('#email-preview');
		
		clearTimeout( this.loadMailTimeout );
		
		this.lastLoadedEmail = emailMessageId;
		
		this.loadMailTimeout = setTimeout(async () => {
			let w = new EmailViewWidget();
			w.setContainer('#email-preview');
			w.setShowHeader( false );
			
			await w.loadEmail( emailMessageId );
		}, 200);
	}
	
	email_DblClick(evt, tr) {
		let id = tr.email.emailMessageId;
		
		clearTimeout( this.loadMailTimeout );
		
		gotoRoute('/email/edit/?id=' + id);
	}
	
	
	render() {
		let ezTpl = new EzTemplate( this.container );
		ezTpl.setObject('widget', this);
		
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.render();
		
		this.search();
		
		$('input[name=q]').focus();
		
		document.getElementById('search-result').addEventListener('scroll', (evt) => {
			let p = evt.target.scrollTop + evt.target.clientHeight;
			
			if (evt.target.scrollHeight - p < 50) {
				this.searchNext();
			}
		});
	}
	
	
	
}


